(************************************************************************
 *                                                                      *
 *   Ant Movie Catalog 4.x                                              *
 *   (C) 2000-2006 Antoine Potten                                       *
 *   http://www.antp.be/software                                        *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit Global;

interface

uses
  SysUtils, Controls, ImgList,

  AntTranslator,

  ProgramSettings, MessageForm, InputForm, Progress;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

var
  Settings: TSettings;
  Translator: TAntTranslator;
  ToolbarImages: TCustomImageList;
  MessageWin: TMessageWin;
  InputWin: TInputWin;
  ProgressWin: TProgressWin;
  FormatSettings: TFormatSettings;
  OldFormatSettings: TFormatSettings;

function CheckVersion(const Major, Minor, Revision: Integer; CurVersion: string = ''): Boolean; overload;
function CheckVersion(AVersion: string; CurVersion: string = ''): Boolean; overload;
function GetFormattedTitle(OriginalTitle, TranslatedTitle, MediaLabel: string; DisplayType: Integer = -1; UsePrefixes: Boolean = False): string;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

implementation

uses
  Windows,

  functions_files, functions_str;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function CheckVersion(const Major, Minor, Revision: Integer; CurVersion: string = ''): Boolean;
var
  Zero: Integer;
begin
  Zero := Integer('0');
  if CurVersion = '' then
    CurVersion := Settings.version;
  Result := False;
  if Major < (Integer(CurVersion[1]) - Zero) then
    Result := True
  else
    if Major = (Integer(CurVersion[1]) - Zero) then
      if Minor < (Integer(CurVersion[3]) - Zero) then
        Result := True
      else
        if Minor = (Integer(CurVersion[3]) - Zero) then
          if Revision <= (Integer(CurVersion[5]) - Zero) then
            Result := True;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function CheckVersion(AVersion: string; CurVersion: string = ''): Boolean;
var
  Major, Minor, Revision: string;
  s: string;
begin
  Assert(False, 'Never tested');
  if CurVersion = '' then
    CurVersion := Settings.version;
  Split(AVersion, '.', Major, s, True);
  AVersion := s;
  Split(Aversion, '.', Minor, s, True);
  AVersion := s;
  Split(AVersion, '.', Revision, s, True);
  Result := CheckVersion(StrToIntDef(Major, 0), StrToIntDef(Minor, 0), StrToIntDef(Revision, 0), CurVersion);
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function PrefixTitle(const ATitle: string): string;
var
  StartPos, Idx: Integer;
  Prefix: string;
begin
  Result := ATitle;
  StartPos := 1;
  while StartPos <= Length(ATitle) do
  begin
    if ATitle[StartPos] in ['''', ' '] then
      Break;
    inc(StartPos);
  end;
  if (StartPos > 0) and (StartPos <= Length(ATitle)) then
  begin
    Prefix := Copy(ATitle, 1, StartPos - 1);
    if Prefix <> '' then
    begin
      Idx := Settings.rOptions.rMovieList.Prefixes.IndexOf(Prefix);
      if Idx > -1 then
      begin
        Result := TrimRight(UpperCase(ATitle[StartPos + 1]) + Copy(ATitle, StartPos + 2, Length(ATitle)) + ', ' + Prefix + ATitle[StartPos]);
      end;
    end;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function GetFormattedTitle(OriginalTitle, TranslatedTitle, MediaLabel: string;
    DisplayType: Integer = -1; UsePrefixes: Boolean = False): string;
begin
  Result := '';
  if not (DisplayType in [0..3]) then
    DisplayType := Settings.rOptions.rMovieList.TitleColumn;
  if UsePrefixes then
  begin
    OriginalTitle := PrefixTitle(OriginalTitle);
    TranslatedTitle := PrefixTitle(TranslatedTitle);
  end;
  case DisplayType of
    0:
      begin // Original title only
        Result := OriginalTitle;
      end;
    1:
      begin // Translated title if available
        if TranslatedTitle <> '' then
          Result := TranslatedTitle
        else
          Result := OriginalTitle;
      end;
    2:
      begin // "Original title (translated title)"
          if TranslatedTitle = '' then
            Result := OriginalTitle
          else
          if OriginalTitle = '' then
            Result := TranslatedTitle
          else
            Result := OriginalTitle + ' (' + TranslatedTitle + ')';
      end;
    3:
      begin // "Translated title (original title)"
          if OriginalTitle = '' then
            Result := TranslatedTitle
          else
          if TranslatedTitle = '' then
            Result := OriginalTitle
          else
          if TranslatedTitle <> '' then
            Result := TranslatedTitle + ' (' + OriginalTitle + ')';
      end;
    4:
      begin
        Result := MediaLabel;
      end;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

initialization
  GetLocaleFormatSettings(GetThreadLocale, FormatSettings);
  GetLocaleFormatSettings(GetThreadLocale, OldFormatSettings);
  with OldFormatSettings do
  begin
    ThousandSeparator := #0;
    DecimalSeparator := '.';
    //DateSeparator := '-';
    //ShortDateFormat := 'yyyy-mm-dd';
    DateSeparator := '/';
    ShortDateFormat := 'dd/mm/yyyy';
    TimeSeparator := ':';
    ShortTimeFormat := 'HH:nn';
    LongTimeFormat := 'HH:nn:ss';
  end;
  with FormatSettings do
  begin
    ThousandSeparator := #0;
    DecimalSeparator := '.';
    DateSeparator := '-';
    ShortDateFormat := 'yyyy-mm-dd';
    //DateSeparator := '/';
    //ShortDateFormat := 'dd/mm/yyyy';
    TimeSeparator := ':';
    ShortTimeFormat := 'HH:nn';
    LongTimeFormat := 'HH:nn:ss';
  end;
end.
